/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.hash;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.directory.api.ldap.model.constants.LdapSecurityConstants;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.password.PasswordUtil;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.server.config.beans.HashInterceptorBean;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.interceptor.BaseInterceptor;
import org.apache.directory.server.core.api.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;

public class ConfigurableHashingInterceptor
extends BaseInterceptor {
    private HashInterceptorBean config;
    private LdapSecurityConstants algorithm;
    private List<AttributeType> attributeTypes;

    public ConfigurableHashingInterceptor(HashInterceptorBean config) {
        this.config = config;
    }

    @Override
    public void add(AddOperationContext addContext) throws LdapException {
        if (this.algorithm == null) {
            this.next(addContext);
            return;
        }
        for (Attribute attribute : addContext.getEntry().getAttributes()) {
            if (!this.attributeTypes.contains(attribute.getAttributeType())) continue;
            this.includeHashed(attribute);
        }
        this.next(addContext);
    }

    public LdapSecurityConstants getAlgorithm() {
        return this.algorithm;
    }

    public List<AttributeType> getAttributeTypes() {
        return Collections.unmodifiableList(this.attributeTypes);
    }

    private void includeHashed(Attribute attribute) throws LdapInvalidAttributeValueException {
        if (attribute == null) {
            return;
        }
        ArrayList<byte[]> values = new ArrayList<byte[]>();
        for (Value value : attribute) {
            byte[] bytes = value.getBytes();
            if (bytes == null) continue;
            LdapSecurityConstants existingAlgo = PasswordUtil.findAlgorithm(bytes);
            if (existingAlgo == null) {
                values.add(PasswordUtil.createStoragePassword(bytes, this.algorithm));
                continue;
            }
            values.add(bytes);
        }
        attribute.clear();
        attribute.add((byte[][])values.toArray((T[])new byte[values.size()][]));
    }

    @Override
    public void init(DirectoryService directoryService) throws LdapException {
        super.init(directoryService);
        this.algorithm = LdapSecurityConstants.getAlgorithm(this.config.getHashAlgorithm());
        this.attributeTypes = new ArrayList<AttributeType>();
        for (String attributeType : this.config.getHashAttributes()) {
            this.attributeTypes.add(this.schemaManager.lookupAttributeTypeRegistry(attributeType));
        }
    }

    @Override
    public void modify(ModifyOperationContext modifyContext) throws LdapException {
        if (this.algorithm == null) {
            this.next(modifyContext);
            return;
        }
        List<Modification> mods = modifyContext.getModItems();
        for (Modification mod : mods) {
            Attribute attribute = mod.getAttribute();
            if (!this.attributeTypes.contains(attribute.getAttributeType())) continue;
            this.includeHashed(attribute);
        }
        this.next(modifyContext);
    }
}

