/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.message;

import org.apache.directory.api.ldap.model.message.LdapResult;
import org.apache.directory.api.ldap.model.message.Referral;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.name.Dn;

public class LdapResultImpl
implements LdapResult {
    private Dn matchedDn;
    private Referral referral;
    private String diagnosticMessage;
    private ResultCodeEnum resultCode = ResultCodeEnum.SUCCESS;
    private boolean isDefaultSuccess = true;

    @Override
    public String getDiagnosticMessage() {
        return this.diagnosticMessage;
    }

    @Override
    public void setDiagnosticMessage(String diagnosticMessage) {
        this.diagnosticMessage = diagnosticMessage;
        this.isDefaultSuccess = false;
    }

    @Override
    public Dn getMatchedDn() {
        return this.matchedDn;
    }

    @Override
    public void setMatchedDn(Dn matchedDn) {
        this.matchedDn = matchedDn;
        this.isDefaultSuccess = false;
    }

    @Override
    public ResultCodeEnum getResultCode() {
        return this.resultCode;
    }

    @Override
    public void setResultCode(ResultCodeEnum resultCode) {
        this.resultCode = resultCode;
        this.isDefaultSuccess = this.isDefaultSuccess && resultCode == ResultCodeEnum.SUCCESS;
    }

    @Override
    public Referral getReferral() {
        return this.referral;
    }

    @Override
    public boolean isReferral() {
        return this.referral != null;
    }

    @Override
    public void setReferral(Referral referral) {
        this.referral = referral;
        this.isDefaultSuccess = false;
    }

    @Override
    public boolean isDefaultSuccess() {
        return this.isDefaultSuccess;
    }

    public int hashCode() {
        int hash = 37;
        if (this.referral != null) {
            hash = hash * 17 + this.referral.hashCode();
        }
        hash = hash * 17 + this.resultCode.hashCode();
        if (this.diagnosticMessage != null) {
            hash = hash * 17 + this.diagnosticMessage.hashCode();
        }
        if (this.matchedDn != null) {
            hash = hash * 17 + this.matchedDn.hashCode();
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LdapResult)) {
            return false;
        }
        LdapResult result = (LdapResult)obj;
        if (this.referral == null && result.getReferral() != null) {
            return false;
        }
        if (result.getReferral() == null && this.referral != null) {
            return false;
        }
        if (this.referral != null && result.getReferral() != null && !this.referral.equals(result.getReferral())) {
            return false;
        }
        if (!this.resultCode.equals((Object)result.getResultCode())) {
            return false;
        }
        String errMsg0 = this.diagnosticMessage;
        String errMsg1 = result.getDiagnosticMessage();
        if (errMsg0 == null) {
            errMsg0 = "";
        }
        if (errMsg1 == null) {
            errMsg1 = "";
        }
        if (!errMsg0.equals(errMsg1)) {
            return false;
        }
        return !(this.matchedDn != null ? !this.matchedDn.equals(result.getMatchedDn()) : result.getMatchedDn() != null);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("        Ldap Result\n");
        sb.append("            Result code : (").append((Object)this.resultCode).append(')');
        block0 : switch (this.resultCode) {
            case SUCCESS: {
                sb.append(" success\n");
                break;
            }
            case OPERATIONS_ERROR: {
                sb.append(" operationsError\n");
                break;
            }
            case PROTOCOL_ERROR: {
                sb.append(" protocolError\n");
                break;
            }
            case TIME_LIMIT_EXCEEDED: {
                sb.append(" timeLimitExceeded\n");
                break;
            }
            case SIZE_LIMIT_EXCEEDED: {
                sb.append(" sizeLimitExceeded\n");
                break;
            }
            case COMPARE_FALSE: {
                sb.append(" compareFalse\n");
                break;
            }
            case COMPARE_TRUE: {
                sb.append(" compareTrue\n");
                break;
            }
            case AUTH_METHOD_NOT_SUPPORTED: {
                sb.append(" authMethodNotSupported\n");
                break;
            }
            case STRONG_AUTH_REQUIRED: {
                sb.append(" strongAuthRequired\n");
                break;
            }
            case REFERRAL: {
                sb.append(" referral -- new\n");
                break;
            }
            case ADMIN_LIMIT_EXCEEDED: {
                sb.append(" adminLimitExceeded -- new\n");
                break;
            }
            case UNAVAILABLE_CRITICAL_EXTENSION: {
                sb.append(" unavailableCriticalExtension -- new\n");
                break;
            }
            case CONFIDENTIALITY_REQUIRED: {
                sb.append(" confidentialityRequired -- new\n");
                break;
            }
            case SASL_BIND_IN_PROGRESS: {
                sb.append(" saslBindInProgress -- new\n");
                break;
            }
            case NO_SUCH_ATTRIBUTE: {
                sb.append(" noSuchAttribute\n");
                break;
            }
            case UNDEFINED_ATTRIBUTE_TYPE: {
                sb.append(" undefinedAttributeType\n");
                break;
            }
            case INAPPROPRIATE_MATCHING: {
                sb.append(" inappropriateMatching\n");
                break;
            }
            case CONSTRAINT_VIOLATION: {
                sb.append(" constraintViolation\n");
                break;
            }
            case ATTRIBUTE_OR_VALUE_EXISTS: {
                sb.append(" attributeOrValueExists\n");
                break;
            }
            case INVALID_ATTRIBUTE_SYNTAX: {
                sb.append(" invalidAttributeSyntax\n");
                break;
            }
            case NO_SUCH_OBJECT: {
                sb.append(" noSuchObject\n");
                break;
            }
            case ALIAS_PROBLEM: {
                sb.append(" aliasProblem\n");
                break;
            }
            case INVALID_DN_SYNTAX: {
                sb.append(" invalidDNSyntax\n");
                break;
            }
            case ALIAS_DEREFERENCING_PROBLEM: {
                sb.append(" aliasDereferencingProblem\n");
                break;
            }
            case INAPPROPRIATE_AUTHENTICATION: {
                sb.append(" inappropriateAuthentication\n");
                break;
            }
            case INVALID_CREDENTIALS: {
                sb.append(" invalidCredentials\n");
                break;
            }
            case INSUFFICIENT_ACCESS_RIGHTS: {
                sb.append(" insufficientAccessRights\n");
                break;
            }
            case BUSY: {
                sb.append(" busy\n");
                break;
            }
            case UNAVAILABLE: {
                sb.append(" unavailable\n");
                break;
            }
            case UNWILLING_TO_PERFORM: {
                sb.append(" unwillingToPerform\n");
                break;
            }
            case LOOP_DETECT: {
                sb.append(" loopDetect\n");
                break;
            }
            case NAMING_VIOLATION: {
                sb.append(" namingViolation\n");
                break;
            }
            case OBJECT_CLASS_VIOLATION: {
                sb.append(" objectClassViolation\n");
                break;
            }
            case NOT_ALLOWED_ON_NON_LEAF: {
                sb.append(" notAllowedOnNonLeaf\n");
                break;
            }
            case NOT_ALLOWED_ON_RDN: {
                sb.append(" notAllowedOnRDN\n");
                break;
            }
            case ENTRY_ALREADY_EXISTS: {
                sb.append(" entryAlreadyExists\n");
                break;
            }
            case OBJECT_CLASS_MODS_PROHIBITED: {
                sb.append(" objectClassModsProhibited\n");
                break;
            }
            case AFFECTS_MULTIPLE_DSAS: {
                sb.append(" affectsMultipleDSAs -- new\n");
                break;
            }
            case E_SYNC_REFRESH_REQUIRED: {
                sb.append(" eSyncRefreshRequired\n");
                break;
            }
            case OTHER: {
                sb.append(" other\n");
                break;
            }
            default: {
                switch (this.resultCode.getResultCode()) {
                    case 9: {
                        sb.append(" -- 9 reserved --\n");
                        break block0;
                    }
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: {
                        sb.append(" -- 22-31 unused --\n");
                        break block0;
                    }
                    case 35: {
                        sb.append(" -- 35 reserved for undefined isLeaf --\n");
                        break block0;
                    }
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: {
                        sb.append(" -- 37-47 unused --\n");
                        break block0;
                    }
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: {
                        sb.append(" -- 55-63 unused --\n");
                        break block0;
                    }
                    case 70: {
                        sb.append(" -- 70 reserved for CLDAP --\n");
                        break block0;
                    }
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 78: 
                    case 79: {
                        sb.append(" -- 72-79 unused --\n");
                        break block0;
                    }
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 90: {
                        sb.append(" -- 81-90 reserved for APIs --");
                        break block0;
                    }
                }
                sb.append("Unknown error code : ").append((Object)this.resultCode);
            }
        }
        sb.append("            Matched Dn : '").append(this.matchedDn).append("'\n");
        sb.append("            Diagnostic message : '").append(this.diagnosticMessage).append("'\n");
        if (this.referral != null) {
            sb.append("            Referrals :\n");
            sb.append("                Referral :").append(this.referral.toString()).append('\n');
        }
        return sb.toString();
    }
}

